/*
 * Decompiled with CFR 0.152.
 */
package com.gharielsl.tfdnv.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WoodChair
extends HorizontalDirectionalBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape SHAPE_NORTH = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0), (VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)10.0, (double)13.0));
    private static final VoxelShape SHAPE_EAST = WoodChair.rotateShape(Direction.NORTH, Direction.EAST, SHAPE_NORTH);
    private static final VoxelShape SHAPE_SOUTH = WoodChair.rotateShape(Direction.NORTH, Direction.SOUTH, SHAPE_NORTH);
    private static final VoxelShape SHAPE_WEST = WoodChair.rotateShape(Direction.NORTH, Direction.WEST, SHAPE_NORTH);

    protected WoodChair() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60955_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_8125_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter block, BlockPos pos, CollisionContext collision) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return switch (facing) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
        if (level instanceof Level) {
            ((Level)level).m_45933_(null, Block.m_49796_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1)).m_83215_()).forEach(entity -> {
                if (entity instanceof ArmorStand && ((ArmorStand)entity).m_31677_()) {
                    entity.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            });
        }
        super.m_6786_(level, pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        for (Entity entity : level.m_45933_(null, Block.m_49796_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1)).m_83215_())) {
            if (entity.m_20197_().contains(player)) {
                return InteractionResult.PASS;
            }
            if (!(entity instanceof ArmorStand) || !((ArmorStand)entity).m_31677_()) continue;
            if (!entity.m_20197_().isEmpty()) {
                return InteractionResult.PASS;
            }
            player.m_20329_(entity);
            return InteractionResult.SUCCESS;
        }
        ArmorStand seat = new ArmorStand(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.3, (double)pos.m_123343_() + 0.5);
        seat.m_6842_(true);
        seat.m_20331_(true);
        seat.m_20242_(true);
        byte flags = (Byte)seat.m_20088_().m_135370_(ArmorStand.f_31524_);
        seat.m_20088_().m_135381_(ArmorStand.f_31524_, (Object)((byte)(flags | 0x10)));
        seat.m_20225_(true);
        seat.m_20340_(false);
        level.m_7967_((Entity)seat);
        player.m_20329_((Entity)seat);
        return InteractionResult.SUCCESS;
    }

    private static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }
}

